#ifndef __CWindowDragTab__
#define __CWindowDragTab__

#include "CControl.hpp"
using Exponent::GUI::Controls::CControl;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CWindowDragTab CWindowDragTab.hpp
			 * @brief Handle to a control
             *
			 * A handle to a window. Provides dragging functionality\n
			 * Couple of caveats:\n
			 * 1. This class directly edits the base class window. Make sure you actually want to do this..\n
			 * 2. This class must be directly added to the root control of a window to have any chance of sucess.\n
			 *
			 * @date 11/06/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CWindowDragTab.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CWindowDragTab : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CWindowDragTab(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CWindowDragTab();

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle the mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

				/**
				 * Draw the controls
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

			protected:

//	===========================================================================

				bool m_mouseIsDown;			/**< Have the clicked in our area */
				CPoint m_dragOffset;		/**< Where did they click inside our area? */
			};
		}
	}
}
#endif	// End of CWindowDragTab.hpp